!function ($) {

  $(function(){

    $('#world_map').vectorMap({
      map: 'world_mill_en',
      normalizeFunction: 'polynomial',
      backgroundColor: '#fff',            
      regionStyle: {
        initial: {
          fill: '#36424f'
        },
       hover: {
          fill: '#1ccc88'
        },
      },
      markerStyle: {
        initial: {
          fill: '#1ccc88',
          stroke: '#fff'
        }
      },
      markers: [
        {latLng: [41.90, 12.45], name: 'Vatican City'},
        {latLng: [43.73, 7.41], name: 'Monaco'},
        {latLng: [-0.52, 166.93], name: 'Nauru'},
        {latLng: [-8.51, 179.21], name: 'Tuvalu'},
        {latLng: [43.93, 12.46], name: 'San Marino'},
        {latLng: [47.14, 9.52], name: 'Liechtenstein'},
        {latLng: [7.11, 171.06], name: 'Marshall Islands'},
        {latLng: [17.3, -62.73], name: 'Saint Kitts and Nevis'},
        {latLng: [3.2, 73.22], name: 'Maldives'},
        {latLng: [35.88, 14.5], name: 'Malta'},
        {latLng: [12.05, -61.75], name: 'Grenada'},
        {latLng: [13.16, -61.23], name: 'Saint Vincent and the Grenadines'},
        {latLng: [13.16, -59.55], name: 'Barbados'},
        {latLng: [17.11, -61.85], name: 'Antigua and Barbuda'},
        {latLng: [-4.61, 55.45], name: 'Seychelles'},
        {latLng: [7.35, 134.46], name: 'Palau'},
        {latLng: [42.5, 1.51], name: 'Andorra'},
        {latLng: [14.01, -60.98], name: 'Saint Lucia'},
        {latLng: [6.91, 158.18], name: 'Federated States of Micronesia'},
        {latLng: [1.3, 103.8], name: 'Singapore'},
        {latLng: [1.46, 173.03], name: 'Kiribati'},
        {latLng: [-21.13, -175.2], name: 'Tonga'},
        {latLng: [15.3, -61.38], name: 'Dominica'},
        {latLng: [-20.2, 57.5], name: 'Mauritius'},
        {latLng: [26.02, 50.55], name: 'Bahrain'},
        {latLng: [0.33, 6.73], name: 'São Tomé and Príncipe'}
      ]
    });
    var map,
    markers = [
      {latLng: [40.71, -74.00], name: 'New York'},
      {latLng: [34.05, -118.24], name: 'Los Angeles'},
      {latLng: [41.87, -87.62], name: 'Chicago'},
      {latLng: [29.76, -95.36], name: 'Houston'},
      {latLng: [39.95, -75.16], name: 'Philadelphia'},
      {latLng: [38.90, -77.03], name: 'Washington'},
      {latLng: [37.36, -122.03], name: 'Silicon Valley'}
    ],
    cityAreaData = [
      187.70,
      255.16,
      310.69,
      605.17,
      248.31,
      107.35,
      217.22
    ];

    map = new jvm.WorldMap({
      container: $('#usa_map'),
      map: 'us_aea_en',
      backgroundColor: '#fff',  
      regionsSelectable: true,
      markersSelectable: true,
      markers: markers,
      markerStyle: {
        initial: {
          fill: '#fcc633'
        },
        selected: {
          fill: '#ffffff'
        }
      },
      regionStyle: {
        initial: {
          fill: '#177bbb'
        },
        selected: {
          fill: '#1ccacc'
        }
      },
      series: {
        markers: [{
          attribute: 'r',
          scale: [5, 15],
          values: cityAreaData
        }]
      },
      onRegionSelected: function(){
        if (window.localStorage) {
          window.localStorage.setItem(
            'jvectormap-selected-regions',
            JSON.stringify(map.getSelectedRegions())
          );
        }
      },
      onMarkerSelected: function(){
        if (window.localStorage) {
          window.localStorage.setItem(
            'jvectormap-selected-markers',
            JSON.stringify(map.getSelectedMarkers())
          );
        }
      }
    });
    

  });
}(window.jQuery);